KasperskyLab.AddRunner("sam", function (ns, session, settings)
{

var SearchMonitor = function ()
{
	var m_callFunction;
	var m_postponeSendStarted = false;
	var m_allreadySentAttribute = "kl_sam" + ns.GetCurrentTime();
	var m_lastSearchRequest = "";
	var m_pingTimeout = ns.MaxRequestDelay;

	function GetHref(link)
	{
		try	{ return link.href;	} catch(e){}
		try	{ return link.getAttribute("href");	} catch(e){}
		return "";
	}

	function IsInterestingLink(link)
	{
		return !link[m_allreadySentAttribute] && ns.IsLinkSearchResult(link);
	}
	function CollectAndSendSearchResults()
	{
		m_postponeSendStarted = false;
		var request = ns.GetSearchSiteRequest();
		var linksForSend = 
			{
				url: document.location.href,
				queryText: request,
				typedText: ns.GetTypedSearchRequest(),
				searchResultUrls : []
			};

		for (var i = 0; i < document.links.length; ++i)
		{
			var link = document.links[i];
			if (IsInterestingLink(link))
			{
				if (!request)
				{
					PostponeCollectAndSendSearchResult();
					return;
				}
				link[m_allreadySentAttribute] = true; 
				var href = GetHref(link);
				if (!!href)
					linksForSend.searchResultUrls.push(href);
				else
					ns.Log("access to href \"" + link.outerHTML + "\" blocked by browser");
			}
		}

		if (request === m_lastSearchRequest && linksForSend.searchResultUrls.length === 0)
			return;

		m_lastSearchRequest = request;
		m_callFunction("sam.SearchResult2", [ns.JSONStringify(linksForSend)]);
	}
	function PostponeCollectAndSendSearchResult()
	{
		if (!m_postponeSendStarted)
		{
			ns.SetTimeout(CollectAndSendSearchResults, 500);
			m_postponeSendStarted = true;
		}
	}

	function OnPing()
	{
	    return m_pingTimeout;
	}

	function OnError(e)
	{
		session.Log('ERR SAM - ' + (e.message || e));
	}

	function ReloadPage()
	{
	    m_callFunction("sam.onReload", []);
	    window.location.reload(true);
	}

	session.InitializePlugin(function(activatePlugin, registerMethod, callFunction)
	{
		m_callFunction = callFunction;
		activatePlugin('sam', OnPing, OnError);
		registerMethod('sam.reloadStart', function () { m_pingTimeout = 500; });
		registerMethod('sam.reloadEnd', function () { m_pingTimeout = ns.MaxRequestDelay; });
		registerMethod('sam.reload', ReloadPage);
	});

	CollectAndSendSearchResults();
	var m_observer = ns.GetDomChangeObserver("a");
	m_observer.Start(PostponeCollectAndSendSearchResult);
	ns.AddEventListener(window, "unload",
		function()
		{
			if (m_observer)
				m_observer.Stop();
		});
};

var instance = null;

function RunSearchMonitor() 
{
	try
	{
		if (!instance)
			instance = new SearchMonitor();
	}
	catch(e)
	{
		session.Log('RunSearchMonitor exception ' + (e.message || e));
	}
}

if (document.readyState === "complete")
{
	RunSearchMonitor();
}
else
{
	ns.AddEventListener(window, "load", function() { RunSearchMonitor();});
	ns.SetTimeout(RunSearchMonitor, 100000);
}

});
